require('dotenv').config();
const express = require('express');
const router = express.Router();
const pool = require('../config/database');

console.log("Database Host:", process.env.DB_HOST);

// แสดงสินค้าหน้าแรก
router.get('/', async (req, res) => {
    try {
        const [products] = await pool.query('SELECT * FROM products WHERE stock > 0');
        res.render('index', { products });
    } catch (error) {
        console.error(error);
        res.status(500).send('Error fetching products');
    }
});

router.post('/add-to-cart', async (req, res) => {
    const { productId, quantity } = req.body;
    try {
        const [productResult] = await pool.query('SELECT * FROM products WHERE id = ? AND stock > 0', [productId]);
        if (productResult.length === 0) {
            return res.status(404).send('Product not found or out of stock');
        }
        const product = productResult[0];

        if (!req.session.cart) {
            req.session.cart = [];
        }

        console.log("Before Editing:", req.session.cart);

        if (req.session.editingItemId) {
            console.log("Replacing Item ID:", req.session.editingItemId);

            // ลบสินค้าที่ต้องการเปลี่ยนออก
            req.session.cart = req.session.cart.filter(item => item.id !== req.session.editingItemId);

            // เพิ่มสินค้าตัวใหม่เข้าไป
            req.session.cart.push({
                id: product.id,
                name: product.name,
                price: product.price,
                quantity: parseInt(quantity),
                stock: product.stock
            });

            console.log("After Editing:", req.session.cart);

            req.session.editingItemId = null; // ล้างค่าหลังเปลี่ยนสินค้าเสร็จ
        } else {
            console.log("Adding New Item");

            // เพิ่มสินค้าตามปกติ
            req.session.cart.push({
                id: product.id,
                name: product.name,
                price: product.price,
                quantity: parseInt(quantity),
                stock: product.stock
            });
        }

        console.log("Final Cart:", req.session.cart);
        res.redirect('/cart'); // กลับไปหน้าตะกร้า
    } catch (error) {
        console.error(error);
        res.status(500).send('Error adding product to cart');
    }
});

module.exports = router;