const bcrypt = require('bcrypt');
const pool = require('../db');

module.exports = {
    showRegisterPage: (req, res) => {
        res.render('register', { message: req.flash('message') });
    },

    registerUser: async (req, res) => {
        const { email, username, fname, lname, rpassword, confirm_password } = req.body;

        // ตรวจสอบว่ารหัสผ่านทั้งสองตรงกันหรือไม่
        if (rpassword !== confirm_password) {
            req.flash('message', 'Passwords do not match!');
            return res.redirect('/register');
        }

        try {
            // ตรวจสอบว่าอีเมลมีอยู่ในระบบหรือไม่
            const [existingUser] = await pool.execute('SELECT * FROM users WHERE email = ?', [email]);
            if (existingUser.length > 0) {
                req.flash('message', 'Email is already registered.');
                return res.redirect('/register');
            }

            // ตรวจสอบว่า username มีอยู่แล้วหรือไม่
            const [existingUsername] = await pool.execute('SELECT * FROM users WHERE username = ?', [username]);
            if (existingUsername.length > 0) {
                req.flash('message', 'Username is already taken.');
                return res.redirect('/register');
            }

            // แฮชรหัสผ่าน
            const hashedPassword = await bcrypt.hash(rpassword, 10);

            // บันทึกข้อมูลผู้ใช้ในฐานข้อมูล
            const query = 'INSERT INTO users (email, username, password, fname, lname) VALUES (?, ?, ?, ?, ?)';
            await pool.execute(query, [email, username, hashedPassword, fname, lname]);

            // ส่งข้อความแจ้งเตือนและเปลี่ยนเส้นทางไปที่หน้า login
            res.redirect('/login');
        } catch (err) {
            console.error('Error inserting user:', err);
            res.status(500).send('Error occurred');
        }
    }
};
