const bcrypt = require('bcrypt');
const pool = require('../db');

module.exports = {
    showLoginPage: (req, res) => {
        res.render('login', { message: req.flash('message') });
    },

    loginUser: async (req, res) => {
        const { email, password } = req.body;  // เปลี่ยนจาก rpassword เป็น password เพื่อให้ชัดเจน
        try {
            const [rows] = await pool.execute('SELECT * FROM users WHERE email = ?', [email]);
            if (rows.length === 0) {
                req.flash('message', 'Email not found');
                return res.redirect('/login');
            }

            const user = rows[0];

            // ตรวจสอบรหัสผ่าน
            const match = await bcrypt.compare(password, user.password); // เปลี่ยน rpassword เป็น password
            if (match) {
                req.session.userId = user.user_id; // ใช้ user_id แทน id
                res.redirect('/'); // ถ้าการเข้าสู่ระบบสำเร็จจะ redirect ไปที่หน้า home
            } else {
                req.flash('message', 'Password incorrect');
                return res.redirect('/login'); // ถ้ารหัสผ่านไม่ตรง
            }
        } catch (err) {
            console.error(err);
            req.flash('message', 'Server error, please try again later');
            res.status(500).redirect('/login'); // ถ้าเกิดข้อผิดพลาดในการเชื่อมต่อฐานข้อมูล
        }
    }
};
