const express = require('express');
const bodyParser = require('body-parser');
const session = require('express-session');
const flash = require('connect-flash');

const app = express();
app.use(express.static('public'));
app.use(express.json());
app.use(express.urlencoded({ extended: true }));
// ไม่จำเป็นต้องใช้ body-parser เพราะ express เองก็รองรับแล้ว
// app.use(bodyParser.urlencoded({ extended: true }));

// ตั้งค่า session
app.use(session({
    secret: 'secretkey',
    resave: true,
    saveUninitialized: true
}));

// ใช้ flash messages
app.use(flash());

// ตั้งค่า view engine เป็น ejs
app.set('view engine', 'ejs');

// กำหนดค่า session สำหรับการเช็คการ login
app.use('*', (req, res, next) => {
    req.session.loggedIn = req.session.userId; // ใช้ session แทน global
    next();
});

// การนำเข้า controller
const indexController = require('./controllers/indexController');
const loginController = require('./controllers/loginController');
const registerController = require('./controllers/registerController');
const logoutController = require('./controllers/logoutController');

// การตั้งค่า route สำหรับการสมัครและเข้าสู่ระบบ
app.get('/', indexController);
app.get('/login', loginController.showLoginPage);
app.post('/user/login', loginController.loginUser);
app.get('/register', registerController.showRegisterPage);
app.post('/user/register', registerController.registerUser);
app.get('/logout', logoutController.logoutUser); // เพิ่ม route สำหรับ logout

const port = process.env.PORT || 3000;
app.listen(port, () => {
    console.log(`Server running on port ${port}`);
});
