const bcrypt = require('bcrypt');
const pool = require('../db');

module.exports = {
    showRegisterPage: (req, res) => {
        res.render('register', { message: req.flash('message') });
    },

    registerUser: async (req, res) => {
        const { email, rpassword } = req.body;

        try {
            const hashedPassword = await bcrypt.hash(rpassword, 10);
            const query = 'INSERT INTO users (email, password) VALUES (?, ?)';
            await pool.execute(query, [email, hashedPassword]);

            req.flash('message', 'User registered successfully. Please log in.');
            res.redirect('/login');
        } catch (err) {
            console.error('Error inserting user:', err);
            res.status(500).send('Error occurred');
        }
    }
};
