// Middleware สำหรับตรวจสอบการล็อกอิน
exports.isAuthenticated = (req, res, next) => {
    if (req.session && req.session.user) {
        return next();
    }
    res.redirect('/auth/login');
};

// Middleware สำหรับตรวจสอบว่าไม่ได้ล็อกอิน (สำหรับหน้า login และ register)
exports.isNotAuthenticated = (req, res, next) => {
    if (req.session && req.session.user) {
        return res.redirect('/products');
    }
    next();
}; 