const express = require('express');
const router = express.Router();
const authController = require('../controllers/authController');
const { isNotAuthenticated } = require('../middleware/auth');

// แสดงหน้าเข้าสู่ระบบ
router.get('/login', isNotAuthenticated, authController.getLoginPage);

// จัดการการเข้าสู่ระบบ
router.post('/login', isNotAuthenticated, authController.login);

// แสดงหน้าสมัครสมาชิก
router.get('/register', isNotAuthenticated, authController.getRegisterPage);

// จัดการการสมัครสมาชิก
router.post('/register', isNotAuthenticated, authController.register);

// ออกจากระบบ
router.get('/logout', authController.logout);

module.exports = router;
