const express = require('express');
const router = express.Router();
const productController = require('../controllers/productController');

// แสดงรายการสินค้าทั้งหมด
router.get('/', productController.getAllProducts);

// แสดงหน้าเพิ่มสินค้า
router.get('/add', productController.addProductPage);

// เพิ่มสินค้าใหม่
router.post('/create', productController.createProduct);

// แสดงหน้าแก้ไขสินค้า
router.get('/edit/:id', productController.editProductPage);

// อัพเดทสินค้า
router.put('/update/:id', productController.updateProduct);

// ลบสินค้า
router.post('/delete/:id', productController.deleteProduct);

// ค้นหาสินค้า
router.get('/search', productController.searchProducts);

// เบิกสินค้า
router.post('/withdraw', productController.showWithdrawConfirmation);
router.post('/confirm-withdraw', productController.confirmWithdraw);

module.exports = router;
