const db = require('../models/db');

// แสดงหน้าจัดการหมวดหมู่
exports.getCategoriesPage = (req, res) => {
    const query = 'SELECT * FROM categories ORDER BY name';
    db.query(query, (err, results) => {
        if (err) {
            console.error('Error fetching categories:', err);
            return res.render('categories', { 
                categories: [], 
                error: 'เกิดข้อผิดพลาดในการดึงข้อมูลหมวดหมู่' 
            });
        }
        res.render('categories', { categories: results });
    });
};

// แสดงรายการหมวดหมู่ทั้งหมด (API)
exports.getAllCategories = (req, res) => {
    const query = 'SELECT * FROM categories ORDER BY name';
    db.query(query, (err, results) => {
        if (err) {
            console.error('Error fetching categories:', err);
            return res.status(500).json({ error: 'เกิดข้อผิดพลาดในการดึงข้อมูลหมวดหมู่' });
        }
        res.json(results);
    });
};

// เพิ่มหมวดหมู่ใหม่
exports.createCategory = (req, res) => {
    const { name, description } = req.body;
    const query = 'INSERT INTO categories (name, description) VALUES (?, ?)';
    
    db.query(query, [name, description], (err, result) => {
        if (err) {
            console.error('Error creating category:', err);
            return res.redirect('/categories?error=เกิดข้อผิดพลาดในการเพิ่มหมวดหมู่');
        }
        res.redirect('/categories');
    });
};

// แก้ไขหมวดหมู่
exports.updateCategory = (req, res) => {
    const { id } = req.params;
    const { name, description } = req.body;
    const query = 'UPDATE categories SET name = ?, description = ? WHERE id = ?';
    
    db.query(query, [name, description, id], (err, result) => {
        if (err) {
            console.error('Error updating category:', err);
            return res.redirect('/categories?error=เกิดข้อผิดพลาดในการแก้ไขหมวดหมู่');
        }
        res.redirect('/categories');
    });
};

// ลบหมวดหมู่
exports.deleteCategory = (req, res) => {
    const { id } = req.params;
    
    // ตรวจสอบว่ามีสินค้าที่ใช้หมวดหมู่นี้อยู่หรือไม่
    const checkProductsQuery = 'SELECT COUNT(*) as count FROM products WHERE category_id = ?';
    db.query(checkProductsQuery, [id], (err, results) => {
        if (err) {
            console.error('Error checking products:', err);
            return res.redirect('/categories?error=เกิดข้อผิดพลาดในการลบหมวดหมู่');
        }

        if (results[0].count > 0) {
            return res.redirect('/categories?error=ไม่สามารถลบหมวดหมู่ได้เนื่องจากมีสินค้าที่ใช้หมวดหมู่นี้อยู่');
        }

        // ถ้าไม่มีสินค้าที่ใช้หมวดหมู่นี้ ให้ลบได้
        const deleteQuery = 'DELETE FROM categories WHERE id = ?';
        db.query(deleteQuery, [id], (err, result) => {
            if (err) {
                console.error('Error deleting category:', err);
                return res.redirect('/categories?error=เกิดข้อผิดพลาดในการลบหมวดหมู่');
            }
            res.redirect('/categories');
        });
    });
}; 