const bcrypt = require('bcrypt');
const db = require('../models/db');

// แสดงหน้าเข้าสู่ระบบ
exports.getLoginPage = (req, res) => {
    res.render('login', { error: null });
};

// จัดการการเข้าสู่ระบบ
exports.login = (req, res) => {
    const { username, password } = req.body;
    const query = 'SELECT * FROM users WHERE username = ?';

    db.query(query, [username], async (err, results) => {
        if (err) {
            console.error('Error during login:', err);
            return res.render('login', { error: 'เกิดข้อผิดพลาดในการเข้าสู่ระบบ' });
        }

        if (results.length === 0) {
            return res.render('login', { error: 'ไม่พบผู้ใช้งานนี้ในระบบ' });
        }

        const user = results[0];
        const validPassword = await bcrypt.compare(password, user.password);

        if (!validPassword) {
            return res.render('login', { error: 'รหัสผ่านไม่ถูกต้อง' });
        }

        req.session.user = {
            id: user.id,
            username: user.username
        };

        res.redirect('/products');
    });
};

// แสดงหน้าสมัครสมาชิก
exports.getRegisterPage = (req, res) => {
    res.render('register', { error: null });
};

// จัดการการสมัครสมาชิก
exports.register = async (req, res) => {
    const { username, password } = req.body;

    // ตรวจสอบว่ามีผู้ใช้นี้อยู่แล้วหรือไม่
    const checkQuery = 'SELECT * FROM users WHERE username = ?';
    db.query(checkQuery, [username], async (err, results) => {
        if (err) {
            console.error('Error checking username:', err);
            return res.render('register', { error: 'เกิดข้อผิดพลาดในการตรวจสอบชื่อผู้ใช้' });
        }

        if (results.length > 0) {
            return res.render('register', { error: 'ชื่อผู้ใช้นี้มีอยู่ในระบบแล้ว' });
        }

        // เข้ารหัสรหัสผ่าน
        const salt = await bcrypt.genSalt(10);
        const hashedPassword = await bcrypt.hash(password, salt);

        // บันทึกผู้ใช้ใหม่
        const insertQuery = 'INSERT INTO users (username, password) VALUES (?, ?)';
        db.query(insertQuery, [username, hashedPassword], (err, result) => {
            if (err) {
                console.error('Error creating user:', err);
                return res.render('register', { error: 'เกิดข้อผิดพลาดในการสร้างบัญชีผู้ใช้' });
            }

            res.redirect('/auth/login');
        });
    });
};

// ออกจากระบบ
exports.logout = (req, res) => {
    req.session.destroy((err) => {
        if (err) {
            console.error('Error during logout:', err);
        }
        res.redirect('/auth/login');
    });
};