const express = require('express');
const router = express.Router();
const categoryController = require('../controllers/categoryController');
const { isAuthenticated } = require('../middleware/auth');

// แสดงหน้าจัดการหมวดหมู่
router.get('/', isAuthenticated, categoryController.getCategoriesPage);

// แสดงรายการหมวดหมู่ทั้งหมด (API)
router.get('/api', isAuthenticated, categoryController.getAllCategories);

// เพิ่มหมวดหมู่ใหม่
router.post('/create', isAuthenticated, categoryController.createCategory);

// แก้ไขหมวดหมู่
router.put('/:id', isAuthenticated, categoryController.updateCategory);

// ลบหมวดหมู่
router.delete('/:id', isAuthenticated, categoryController.deleteCategory);

module.exports = router; 