const db = require('../config/database');

class Tour {
  static async getAllTours() {
    const [rows] = await db.query('SELECT * FROM tours');
    return rows;
  }

  static async getTourById(id) {
    const [rows] = await db.query('SELECT * FROM tours WHERE id = ?', [id]);
    return rows[0];
  }
}

const bcrypt = require('bcryptjs');

class User {
    static findOne(email, callback) {
        const query = 'SELECT * FROM users WHERE email = ?';
        req.db.query(query, [email], (err, results) => {
            if (err) return callback(err);
            callback(null, results[0]);
        });
    }

    static create(name, email, password, callback) {
        const query = 'INSERT INTO users (name, email, password) VALUES (?, ?, ?)';
        bcrypt.hash(password, 10, (err, hashedPassword) => {
            if (err) return callback(err);
            req.db.query(query, [name, email, hashedPassword], (err, results) => {
                if (err) return callback(err);
                callback(null, results.insertId);
            });
        });
    }

    static comparePassword(email, password, callback) {
        User.findOne(email, (err, user) => {
            if (err || !user) return callback(err || 'User not found');
            bcrypt.compare(password, user.password, (err, isMatch) => {
                if (err) return callback(err);
                callback(null, isMatch);
            });
        });
    }
}

module.exports = User;
module.exports = Tour;
