const { User, Tour } = require('../models/tourModel');

exports.getTours = async (req, res) => {
    try {
      const tours = await Tour.getAllTours();
      res.render('index', { tours,session: req.session });
    } catch (error) {
      res.status(500).send(error.message);
    }
  };
  
  exports.getTourDetails = async (req, res) => {
    try {
      const tour = await Tour.getTourById(req.params.id);
      res.render('tour-details', { tour });
    } catch (error) {
      res.status(500).send(error.message);
    }
  };

//User//
exports.getLogin = (req, res) => {
  res.render('login', { message: null });
};

exports.getRegister = (req, res) => {
  res.render('register', { message: null });
};

exports.postRegister = async (req, res) => {
  const { name, email, password, confirmPassword } = req.body;

  if (password !== confirmPassword) {
      return res.render('register', { message: 'Passwords do not match' });
  }

  try {
      const existingUser = await User.findOne(email);
      if (existingUser) {
          return res.render('register', { message: 'Email already in use' });
      }

      const userId = await User.create(name, email, password);
      req.session.userId = userId;
      res.redirect('/login');
  } catch (err) {
      console.error(err);
      res.render('register', { message: 'Error creating user' });
  }
};

exports.postLogin = async (req, res) => {
  const { email, password } = req.body;

  try {
      const user = await User.findOne(email); // หาผู้ใช้จากฐานข้อมูล

      if (!user) {
          return res.render('login', { message: 'Invalid email or password' });
      }

      const isMatch = await User.comparePassword(email, password); // ตรวจสอบรหัสผ่าน
      if (!isMatch) {
          return res.render('login', { message: 'Invalid email or password' });
      }

      req.session.userId = user.email; // เก็บ email ใน session
      req.session.userName = user.name; // เก็บชื่อผู้ใช้ใน session
      res.redirect('/'); // เมื่อ login สำเร็จให้ไปหน้า home
  } catch (err) {
      console.error(err);
      res.render('login', { message: 'Error logging in' });
  }
};


exports.Logout = (req, res) => {
  req.session.destroy(() => {
      res.redirect('/');
  });
};

//CRUD
// ฟังก์ชั่นสำหรับแสดงฟอร์มสร้างทัวร์
exports.getCreateTour = (req, res) => {
    res.render('createtour', { message: null }); // ไม่ต้องดึงข้อมูลทัวร์ใด ๆ
};

exports.createTour = async (req, res) => {
    const { name, description, price, duration } = req.body;

    try {
        if (!name || !description || !price || !duration) {
            return res.render('createtour', { message: 'All fields are required!' });
        }

        await Tour.createTour({ name, description, price, duration }); // เพิ่มข้อมูลทัวร์
        res.redirect('/'); // หลังจากสร้างเสร็จให้กลับไปที่หน้าแรก
    } catch (error) {
        console.error('Error creating tour:', error);
        res.render('createtour', { message: 'Error creating tour' });
    }
};
// ฟังก์ชั่นสำหรับสร้างทัวร์
exports.postCreateTour = async (req, res) => {
    const { name, description, price, duration } = req.body;
  
    if (!name || !price || !duration) {
      return res.render('createtour', { message: 'ข้อมูลไม่ครบถ้วน' });
    }
  
    try {
      await Tour.create(name, description, price, duration); // สร้างทัวร์
      res.redirect('/'); // กลับไปหน้าแรกหลังจากสร้างเสร็จ
    } catch (error) {
      console.error(error);
      res.render('createtour', { message: 'เกิดข้อผิดพลาดในการสร้างทัวร์' });
    }
};
  exports.getEditTour = async (req, res) => {
    try {
      const tour = await Tour.getTourById(req.params.id);
      if (!tour) return res.status(404).send('ไม่พบข้อมูลทัวร์');
      res.render('edit-tour', { tour });
    } catch (error) {
      res.status(500).send('เกิดข้อผิดพลาด');
    }
};
  
  exports.postEditTour = async (req, res) => {
    const { name, description, price, duration } = req.body;
    const tourData = { name, description, price, duration };
  
    try {
      await Tour.updateTour(req.params.id, tourData); // คำสั่งในการอัปเดต
      res.redirect('/tour/' + req.params.id); // ไปที่หน้ารายละเอียดทัวร์
    } catch (error) {
      res.status(500).send('เกิดข้อผิดพลาดในการแก้ไขทัวร์');
    }
};
  exports.deleteTour = async (req, res) => {
    try {
      await Tour.deleteTour(req.params.id); // คำสั่งในการลบทัวร์
      res.redirect('/'); // ไปที่หน้า home หลังจากลบทัวร์
    } catch (error) {
      res.status(500).send('เกิดข้อผิดพลาดในการลบทัวร์');
    }
};
    
