const { User, Tour } = require('../models/tourModel');
const pool = require('../config/database');

exports.getTours = async (req, res) => {
    try {
      const tours = await Tour.getAllTours();
      res.render('index', { tours,session: req.session });
    } catch (error) {
      res.status(500).send(error.message);
    }
  };
  
  exports.getTourDetails = async (req, res) => {
    try {
      const tour = await Tour.getTourById(req.params.id);
      res.render('tour-details', { tour });
    } catch (error) {
      res.status(500).send(error.message);
    }
  };

//User//
exports.getLogin = (req, res) => {
  res.render('login', { message: null });
};

exports.getRegister = (req, res) => {
  res.render('register', { message: null });
};

exports.postRegister = async (req, res) => {
  const { name, email, password, confirmPassword } = req.body;

  if (password !== confirmPassword) {
      return res.render('register', { message: 'Passwords do not match' });
  }

  try {
      const existingUser = await User.findOne(email);
      if (existingUser) {
          return res.render('register', { message: 'Email already in use' });
      }

      const userId = await User.create(name, email, password);
      req.session.userId = userId;
      res.redirect('/login');
  } catch (err) {
      console.error(err);
      res.render('register', { message: 'Error creating user' });
  }
};

exports.postLogin = async (req, res) => {
  const { email, password } = req.body;

  try {
      const user = await User.findOne(email); // หาผู้ใช้จากฐานข้อมูล

      if (!user) {
          return res.render('login', { message: 'Invalid email or password' });
      }

      const isMatch = await User.comparePassword(email, password); // ตรวจสอบรหัสผ่าน
      if (!isMatch) {
          return res.render('login', { message: 'Invalid email or password' });
      }

      req.session.userId = user.email; // เก็บ email ใน session
      req.session.userName = user.name; // เก็บชื่อผู้ใช้ใน session
      res.redirect('/'); // เมื่อ login สำเร็จให้ไปหน้า home
  } catch (err) {
      console.error(err);
      res.render('login', { message: 'Error logging in' });
  }
};

exports.Logout = (req, res) => {
  req.session.destroy(() => {
      res.redirect('/');
  });
};

//Profile
exports.getProfilePage = async (req, res) => {
  if (!req.session.userId) {
    return res.redirect('/profile');
  }

  try {
    const user = await User.findById(req.session.userId);
    res.render('profile', { user });
  } catch (err) {
    console.error(err);
    res.redirect('/');
  }
};
exports.getEditProfilePage = async (req, res) => {
  if (!req.session.userId) {
    return res.redirect('/profile');
  }

  try {
    const user = await User.findById(req.session.userId);
    res.render('edit-profile', { user });
  } catch (err) {
    console.error(err);
    res.redirect('/profile');
  }
};

exports.updateProfile = async (req, res) => {
  const { name, email, password } = req.body;

  if (!name || !email) {
    return res.status(400).send('Name and Email are required');
  }

  try {
    let user = await User.findById(req.session.userId);

    // อัปเดตชื่อและอีเมล
    user.name = name;
    user.email = email;

    // อัปเดตพาสเวิร์ดถ้ามีการกรอก
    if (password) {
      user.password = await bcrypt.hash(password, 10);
    }

    await user.save();
    res.redirect('/profile');
  } catch (err) {
    console.error(err);
    res.status(500).send('Error updating profile');
  }
};

//CRUD
// แสดงฟอร์มสร้างทัวร์
exports.getCreateTour = (req, res) => {
  res.render('createtour'); 
};

// บันทึกทัวร์ใหม่
exports.createTour = async (req, res) => {
  try {
    const { name, description, price, duration } = req.body;

    // ตรวจสอบว่าข้อมูลถูกต้อง
    if (!name || !description || !price || !duration) {
      return res.status(400).send('กรุณากรอกข้อมูลให้ครบทุกช่อง');
    }

    await pool.query(
      'INSERT INTO tours (name, description, price, duration) VALUES (?, ?, ?, ?)',
      [name, description, price, duration]
    );
    res.redirect('/'); 
  } catch (error) {
    console.error('Error creating tour:', error);
    res.status(500).send('เกิดข้อผิดพลาดในการสร้างทัวร์');
  }
};
// ฟังก์ชั่นสำหรับสร้างทัวร์
exports.postCreateTour = async (req, res) => {
    const { name, description, price, duration } = req.body;
  
    if (!name || !price || !duration) {
      return res.render('createtour', { message: 'ข้อมูลไม่ครบถ้วน' });
    }
  
    try {
      await Tour.createTour(name, description, price, duration); // สร้างทัวร์
      res.redirect('/'); // กลับไปหน้าแรกหลังจากสร้างเสร็จ
    } catch (error) {
      console.error(error);
      res.render('createtour', { message: 'เกิดข้อผิดพลาดในการสร้างทัวร์' });
    }
};
  exports.getEditTour = async (req, res) => {
    try {
      const tour = await Tour.getTourById(req.params.id);
      if (!tour) return res.status(404).send('ไม่พบข้อมูลทัวร์');
      res.render('edittour', { tour });
    } catch (error) {
      res.status(500).send('เกิดข้อผิดพลาด');
    }
};
  
  exports.postEditTour = async (req, res) => {

    console.log('📥 Data received:', req.body);
    const { name, description, price, duration } = req.body;
    const tourData = { name, description, price, duration };
  
    try {
      await Tour.updateTour(req.params.id, tourData); // คำสั่งในการอัปเดต
      res.redirect('/tour/' + req.params.id); // ไปที่หน้ารายละเอียดทัวร์
    } catch (error) {
      res.status(500).send('เกิดข้อผิดพลาดในการแก้ไขทัวร์');
    }
};
  exports.deleteTour = async (req, res) => {
    try {
      await Tour.deleteTour(req.params.id); // คำสั่งในการลบทัวร์
      res.redirect('/'); // ไปที่หน้า home หลังจากลบทัวร์
    } catch (error) {
      res.status(500).send('เกิดข้อผิดพลาดในการลบทัวร์');
    }
};

//ค้นหาทัวร์
exports.searchTours = async (req, res) => {
  try {
    const searchQuery = req.query.query;
    const tours = await Tour.searchTours(searchQuery);

    // ตรวจสอบว่าผลลัพธ์จาก Tour.searchTours เป็นอาร์เรย์หรือไม่
    if (!Array.isArray(tours)) {
      console.log('ผลลัพธ์จาก searchTours ไม่ใช่ Array:', tours);
      return res.render('search', { tours: [], session: req.session }); // ส่งอาร์เรย์ว่างไปหากไม่ใช่ Array
    }

    res.render('search', { tours, session: req.session });
  } catch (error) {
    console.error('Error searching tours:', error);
    res.status(500).send("Error searching tours");
  }
};
