const express = require('express');
const router = express.Router();
const tourController = require('../controllers/tourController');

// ทัวร์
router.get('/', tourController.getTours); // หน้าหลักที่แสดงทัวร์ทั้งหมด
router.get('/tour/:id', tourController.getTourDetails); // หน้ารายละเอียดของทัวร์

// User
router.get('/login', tourController.getLogin); // หน้าเข้าสู่ระบบ
router.get('/register', tourController.getRegister); // หน้าลงทะเบียน
router.post('/register', tourController.postRegister); // ฟอร์มลงทะเบียน
router.post('/login', tourController.postLogin); // ฟอร์มเข้าสู่ระบบ
router.get('/logout', tourController.Logout); // ออกจากระบบ

// สร้างทัวร์
router.get('/create', tourController.getCreateTour); // หน้าสร้างทัวร์
router.post('/create', tourController.createTour); // บันทึกทัวร์ลงฐานข้อมูล

//แก้ไขทัวร์
router.get('/edit/:id', tourController.getEditTour); // หน้ารายละเอียดของทัวร์
router.post('/edit/:id', tourController.postEditTour); // บันทึกทัวร์ลงฐานข้อมูล

//ลบทัวร์
router.get('/delete/:id', tourController.deleteTour); //ลบทัวร์

//ค้นหา
router.get('/search', tourController.searchTours); //หน้าค้นหาทัวร์

//Profile
router.get('/profile', tourController.getProfilePage);//หน้าโปรไฟล์
router.post('/edit-profile', tourController.updateProfile);// อัปเดตข้อมูลโปรไฟล์

module.exports = router;
