const Tour = require('../models/tourModel');

exports.getTours = async (req, res) => {
  try {
    const tours = await Tour.getAllTours();
    res.render('index', { tours });
  } catch (error) {
    res.status(500).send('เกิดข้อผิดพลาด');
  }
};

exports.getTourDetails = async (req, res) => {
  try {
    const tour = await Tour.getTourById(req.params.id);
    if (!tour) return res.status(404).send('ไม่พบข้อมูล');
    res.render('tour-details', { tour });
  } catch (error) {
    res.status(500).send('เกิดข้อผิดพลาด');
  }
};
