const express = require('express');
const router = express.Router();
const tourController = require('../controllers/tourController');

// ทัวร์
router.get('/', tourController.getTours); // หน้าหลักที่แสดงทัวร์ทั้งหมด
router.get('/tour/:id', tourController.getTourDetails); // หน้ารายละเอียดของทัวร์

// User
router.get('/login', tourController.getLogin); // หน้าเข้าสู่ระบบ
router.get('/register', tourController.getRegister); // หน้าลงทะเบียน
router.post('/register', tourController.postRegister); // ฟอร์มลงทะเบียน
router.post('/login', tourController.postLogin); // ฟอร์มเข้าสู่ระบบ
router.get('/logout', tourController.Logout); // ออกจากระบบ

// สร้างทัวร์
router.get('/tour/create', tourController.getCreateTour); // หน้าสร้างทัวร์
router.post('/tour/create', tourController.createTour); // เพิ่ม route สำหรับการสร้างทัวร์โดยการ POST

module.exports = router;
