const express = require('express');
const bodyParser = require('body-parser');
const dotenv = require('dotenv');
const tourRoutes = require('./routes/tourRoutes');
const session = require('express-session');

dotenv.config();
const app = express();

// ตั้งค่า session middleware
app.use(session({
  secret: process.env.SESSION_SECRET,  
  resave: false,
  saveUninitialized: true
}));

app.set('view engine', 'ejs');
app.use(express.static('public'));
app.use(bodyParser.urlencoded({ extended: false }));
app.use(express.urlencoded({ extended: true }));
app.use(express.json());



app.use('/', tourRoutes);
app.use('/login', tourRoutes);
app.use('/register', tourRoutes);
app.use('/tour', tourRoutes);

const PORT = process.env.PORT || 3000;
app.listen(PORT, () => {
  console.log(`Server is running on port ${PORT}`);
});
