const express = require('express');
const bodyParser = require('body-parser');
const dotenv = require('dotenv');
const tourRoutes = require('./routes/tourRoutes');

dotenv.config();
const app = express();

app.set('view engine', 'ejs');
app.use(express.static('public'));
app.use(bodyParser.urlencoded({ extended: false }));

app.use('/', tourRoutes);

const PORT = process.env.PORT || 3000;
app.listen(PORT, () => {
  console.log(`Server is running on port ${PORT}`);
});
