const db = require('../config/db');

class Tour {
  static async getAllTours() {
    try {
      const [rows] = await db.query('SELECT * FROM tours');
      return rows;
    } catch (error) {
      throw error;
    }
  }

  static async getTourById(id) {
    try {
      const [rows] = await db.query('SELECT * FROM tours WHERE id = ?', [id]);
      return rows.length > 0 ? rows[0] : null;
    } catch (error) {
      throw error;
    }
  }
}

module.exports = Tour;
