const express = require('express');
const bodyParser = require('body-parser');
const dotenv = require('dotenv');
const session = require('express-session');
const authRoutes = require('./routes/authRoutes');
const tourRoutes = require('./routes/tourRoutes');


dotenv.config();
const app = express();

app.use(bodyParser.json());
app.use(bodyParser.urlencoded({ extended: false }));

// ใช้ session สำหรับการล็อกอิน
app.use(session({
  secret: 'bankkhabb', // เปลี่ยนเป็นค่า secret ของคุณ
  resave: false,
  saveUninitialized: true,
  cookie: { secure: false } // ถ้าใช้ HTTPS เปลี่ยนเป็น true
}));

// Routes
app.use('/auth', authRoutes);
app.use('/', tourRoutes);


const PORT = process.env.PORT || 3000;
app.listen(PORT, () => {
  console.log(`Server is running on port ${PORT}`);
});
