import { createRouter, createWebHistory } from 'vue-router'
import Home from '../views/Home.vue'
// import MyPage from '../views/MyPage.vue'

const routes = [
  {
    path: '/',
    name: 'Home',
    component: Home
  },
  {
    path: '/about',
    name: 'About',
    // route level code-splitting
    // this generates a separate chunk (about.[hash].js) for this route
    // which is lazy-loaded when the route is visited.
    component: () => import(/* webpackChunkName: "about" */ '../views/About.vue')
  },
  {
    path: '/mypage/:name',
    name: 'MyPage',
    component: () => import('../views/MyPage.vue'),
    props: true
  },
  {
    path: '/mygame',
    name: 'MyGame',
    component: () => import('../views/MyGame.vue')
  }
]

const router = createRouter({
  history: createWebHistory(process.env.BASE_URL),
  routes
})

export default router
